# AVIF Automator v1.0 Windows 11 - Pobierz gotowy plik!
$ErrorActionPreference = "Stop"

function Write-Log { param([string]$Message); Write-Host "AVIF-Automator: $Message" }

function Test-Command { param([string]$Command); return [bool](Get-Command $Command -ErrorAction SilentlyContinue) }

function Install-IfMissing {
    param([string]$Tool)
    if (-not (Test-Command $Tool)) {
        Write-Log "Instaluję $Tool..."
        if ($Tool -eq "avifenc") { winget install libavif.avifenc }
    }
}

Write-Log "Sprawdzam zależności..."
Install-IfMissing "avifenc"

$QUALITY = 100
Write-Log "QUALITY: $QUALITY"
foreach ($f in $args) { Write-Log "  $f" }

foreach ($f in $args) {
    $out = [System.IO.Path]::ChangeExtension($f, ".avif")
    & avifenc -q $QUALITY "`"$f`"" "`"$out`""
    Write-Log "✅ $f → $out"
}

Write-Log "Konwersja zakończona! Author: Igor Rubas +48 668 256 237 https://a360.pl"